!--------------------------------------------------------------------
! Problem avoiding exponent
!--------------------------------------------------------------------
      REAL*8 FUNCTION EX(x); USE useful_parameters; IMPLICIT NONE
      REAL*8,INTENT(IN) :: x
      IF      ( x>ex_ma) THEN;  ex = big
      ELSE IF (-x>ex_ma) THEN;  ex = sma
      ELSE;                     ex = EXP(x); END IF; RETURN
      END FUNCTION EX
!....................................................................

!*****************************************************
!    Random mumbers
!*****************************************************
      REAL*8 FUNCTION RNDM(m)
      INTEGER m,m1,m2,m3,m11,m20,m22,m9,m31,m0,mg1,mg2,mg3, &
             n1, n2, n3, n4
      REAL*8 :: r, rinv
      parameter (r=2147483647.d0,m11=2048,m20=1048576,m22=4194304, &
               m9=512,m31=2147483647,m0=1,mg1=917,mg2=78,mg3=291)
      parameter (rinv = 1.0D0/r, n1 = (1.d-12*r), n2 = (1.d-9*r), &
                n3 = ((1. - 1.d-12)*r), n4 = ((1. - 1.d-9)*r))

      if(m.lt.0) print*, 'just normal practice m =',m

      m1 = iand(m, m11-1)
      m2 = iand((m-m1)/m11, m11-1)
      m3 = (m-m2*m11-m1)/m22
      m  = -m31 + mg1*m1 - m0 &
          + m11*iand(mg1*m2+mg2*m1, m20-1) &
          + m22*iand(mg1*m3+mg3*m1+mg2*m2, m9-1)
      if(m.lt.0) then
         m=m0+m
         m=m+m31
      end if

      if(m .lt. n1) m = n2
      if(m .gt. n3) m = n4
      rndm=dfloat(m)*rinv

      END function RNDM
!-----------------------------------------------------

!--------------------------------------------------------------------
! Ordering dimension
!--------------------------------------------------------------------
	SUBROUTINE ORDERD(n,a,b)
        IMPLICIT NONE
        INTEGER,INTENT(IN)              :: n
	  REAL*8,DIMENSION(n),INTENT(IN)  :: a
	  REAL*8,DIMENSION(n),INTENT(OUT) :: b
        INTEGER :: i,l; REAL*8 :: x
        b(1:n)=a(1:n)
	  DO i=2,n; l=i
2	    IF(b(l)<b(l-1))GOTO 1
	    x=b(l);	b(l)=b(l-1); b(l-1)=x; l=l-1;
          IF(l>=2)GOTO 2
1        CONTINUE;
        ENDDO;
      END SUBROUTINE ORDERD
!....................................................................

!--------------------------------------------------------------------
! Making height limiting function from free runs for refinement
!--------------------------------------------------------------------
      SUBROUTINE HEIGHT_LIMIT
      USE float_configuration; USE global_control
      USE ext_control_data  ; USE time_data
      IMPLICIT NONE

      REAL*8,EXTERNAL :: HELI
      INTEGER :: i_glo_refsuc,iak,nmnms,ih,i_str,i_hi
      INTEGER :: ifw
      REAL*8 :: pom_0,pro_h0,pto_t0,width,alef_0,arig_0,alef,arig
      REAL*8 :: zyt_l,zyt_r,xixi

      OPEN(UNIT=4,FILE='glo_run.dat')
      READ(4,*)ivoid,ivoid,i_glo_refsuc; CLOSE(4)

      OPEN(UNIT=4,       FILE='glo_conf.dat' ,ACCESS='direct', &
            RECL=conf_init, FORM='unformatted')

      hi_flo_hei(0:num_his_hei)=0.0d0

      DO iak=1,i_glo_refsuc
       READ(4,REC=iak)nmnms, &
        om_3(1:nmnms),to_t3(1:nmnms),ro_h3(1:nmnms)

!Histogram formation for one configuration beginning
      DO ih = 1 , nmnms
         pom_0=om_3(ih) ; pro_h0=ro_h3(ih) ; pto_t0=to_t3(ih)
         width = (pto_t0/pro_h0)
         alef_0 = pom_0 - width/un2 ; arig_0 = pom_0 + width/un2
         alef=alef_0 ;arig=arig_0
         i_str = (((alef-om_min)*num_his_hei)/(om_max-om_min))
         i_hi  = (((arig-om_min)*num_his_hei)/(om_max-om_min))
         ! Avoiding outside points ---------------------------------------
         IF(i_hi<0)THEN;                    CYCLE
         ELSE IF(i_str>num_his)THEN;  CYCLE
         ELSE;
               IF(i_str<0)THEN
                    i_str=-1;
                    alef=om_grid_hei(0)-sh_his_hei
               ENDIF
               IF(i_hi>num_his)THEN
                    i_hi=num_his+1;
                    arig=om_grid_hei(num_his_hei)+sh_his_hei
               ENDIF
         ENDIF
         ! Distributing weight to hystogram cells.............................
         IF(i_hi.eq.i_str) THEN
            hi_flo_hei(i_str)=hi_flo_hei(i_str)+ &
                                     pro_h0*(width/sh_his_hei)
         ELSE IF(i_hi.eq.i_str+1) THEN
            zyt_l=(om_grid_hei(i_str+1)-alef)/sh_his_hei
            zyt_r=(arig-om_grid_hei(i_hi))/sh_his_hei
            IF(zyt_l>0.0d0)hi_flo_hei(i_str)= &
                                  hi_flo_hei(i_str)+pro_h0*zyt_l
            IF(zyt_r>0.0d0)hi_flo_hei(i_hi)= &
                                hi_flo_hei(i_hi)+pro_h0*zyt_r
         ELSE
            zyt_l=(om_grid_hei(i_str+1)-alef)/sh_his_hei
            zyt_r=(arig-om_grid_hei(i_hi))/sh_his_hei
            IF(zyt_l>0.0d0)hi_flo_hei(i_str)= &
                                   hi_flo_hei(i_str)+pro_h0*zyt_l
            IF(zyt_r>0.0d0)hi_flo_hei(i_hi)= &
                                   hi_flo_hei(i_hi)+pro_h0*zyt_r
            DO ifw=i_str+1,i_hi-1
               hi_flo(ifw)=hi_flo(ifw)+pro_h0
            ENDDO
         ENDIF
      ENDDO
!Histogram formation for one configuration end

      ENDDO
      CLOSE(4)

      hi_flo_hei(0:num_his_hei)=hi_flo_hei(0:num_his_hei)/i_glo_refsuc

      PRINT*,"Norma free height limit : ", &
                  SUM(hi_flo_hei(0:num_his_hei))*sh_his_hei

      OPEN(UNIT=4,FILE="height_lim.dat")
      DO iak=0,1000; xixi = ((om_max-om_min)/1000)*iak
         WRITE(4,*)xixi,HELI(xixi)
      ENDDO
      CLOSE(4)

      END SUBROUTINE HEIGHT_LIMIT
!....................................................................

!--------------------------------------------------------------------
! Calculating height limit for given omega
!--------------------------------------------------------------------
      REAL*8 function HELI(omeome)
      USE global_control; USE ext_control_data;
      IMPLICIT NONE
      REAL*8,INTENT(IN) :: omeome
      INTEGER :: ihei

        ihei=(omeome-om_min)/sh_his_hei;
        heli=hi_flo_hei(ihei)

      END function HELI
!....................................................................

!--------------------------------------------------------------------
!     Linear interpolation for tabulation
!--------------------------------------------------------------------
      REAL*8 FUNCTION AVVA(ii,x)
      USE tabul_dat; USE ext_control_data; IMPLICIT NONE
      REAL*8,INTENT(IN) :: x
      INTEGER,INTENT(IN) :: ii
      REAL*8 :: sle_x,spr_x,sle,spr
      INTEGER :: jl,jp

      jl=INT((x-om_min_tab)/sha_tab);
      jp=jl+1; sle_x=om_tab(jl); spr_x=om_tab(jp)
      sle=tab(ii,jl); spr=tab(ii,jp)
      avva = sle + (x-sle_x)*((spr-sle)/(spr_x-sle_x))

      END FUNCTION AVVA
!............................

!--------------------------------------------------------------------
!     Integration for tabulation
!--------------------------------------------------------------------
      REAL*8 FUNCTION AKKA(ii,xr,xl)
      USE tabul_dat; USE ext_control_data; IMPLICIT NONE
      REAL*8,EXTERNAL :: AVVA
      REAL*8,INTENT(IN) :: xl,xr
      INTEGER,INTENT(IN) :: ii
      REAL*8,PARAMETER :: s_l=1.0d+50

      IF(xl<=om_min.OR.xr>om_max)THEN
         !PRINT*,' ALARM in AKKA, xl=',xl,'  xr=',xr;
         akka=s_l; RETURN
      ENDIF
      akka = AVVA(ii,xr)-AVVA(ii,xl)

      END FUNCTION AKKA
!............................

!--------------------------------------------------------------------
! Acquiring .TRUE. value if one of input limits is outside of
! the range [om_min, om_max]
! Making gc() totally incorrect
!--------------------------------------------------------------------
      LOGICAL FUNCTION HERA(xa1,xa2)
      USE ext_control_data; USE global_control; USE time_data
      IMPLICIT NONE;
      REAL*8,INTENT(IN) :: xa1,xa2
      LOGICAL,EXTERNAL :: WRONG

      hera = .FALSE.
! making "hera" TRUE if outside if range
      IF(xa1 < om_min .OR. xa1 > om_max) hera = .TRUE.
      IF(xa2 < om_min .OR. xa2 > om_max) hera = .TRUE.
! making "hera" true" if xa1 or xa2 are NAN
      IF(WRONG(xa1)) hera=.TRUE.
      IF(WRONG(xa2)) hera=.TRUE.
 ! Making gc() incorrect if "hera" is true
      IF(hera)THEN
          SELECT CASE(kernel_type)
              CASE(0,1,2,3)
                  gc(1:nt) = SQRT(HUGE(1.0d0))/1.0d5;
              CASE(4,5)
                  gc_MA(1:nt)=DCMPLX(SQRT(HUGE(1.0d0))/1.0d5,SQRT(HUGE(1.0d0))/1.0d5)
          END SELECT        
      ENDIF
          
      END FUNCTION HERA
!....................................................................

!--------------------------------------------------------------------
! Acquiring .TRUE. if "value" is undefioned
!--------------------------------------------------------------------
      LOGICAL function WRONG(value)
      REAL*8,INTENT(IN) :: value
      INTEGER :: casik

      wrong=.FALSE.
      casik=3
      IF(value >= 0.0d0) casik = 1
      IF(value <  0.0d0) casik = 2
      IF(casik==3)THEN
         PRINT*,"VALUE = ",value; wrong=.TRUE.
      ENDIF

      END function WRONG
!....................................................................

!************************************************************************
!   Function to minimize for ro_h0-om_0 gradient descend
!------------------------------------------------------------------------
      SUBROUTINE CHE_HEI(do_togo,ist,no_over)
      USE float_configuration; USE global_control; USE ext_control_data;
      IMPLICIT NONE
      INTEGER,INTENT(IN) :: ist
      LOGICAL,INTENT(IN) :: do_togo
      LOGICAL,INTENT(INOUT) :: no_over
      INTEGER :: ihei
      REAL*8 :: ma_he

      IF(do_togo)THEN

          ido_hei=0
          no_over=.TRUE.;
          DO i=1,nmnm
           ihei=(om_0(i)-om_min)/sh_his_hei; ma_he=hi_flo_hei(ihei)
           IF(ro_h0(i) > buzi*ma_he)THEN
              no_over=.FALSE.; ido_hei=ido_hei+1
           ENDIF
          ENDDO

      ELSE

          ipo_hei=0
          DO i=1,nmnm
          ihei=(om_0(i)-om_min)/sh_his_hei; ma_he=hi_flo_hei(ihei)
          IF(ro_h0(i) > buzi*ma_he)THEN
             ipo_hei=ipo_hei+1
          ENDIF
          ENDDO

          IF(ipo_hei>ido_hei)THEN
             IF(ist==5)THEN
               CONTINUE;  !PRINT*,"Status    = ",ist; PRINT*,"Vert slice overrun"
               !PRINT*,"Ido_hei = ",ido_hei,"    Ipo_hei = ",ipo_hei
             ELSE
                 PRINT*,"Ido_hei = ",ido_hei,"    Ipo_hei = ",ipo_hei
                 PRINT*,"Status    = ",ist;    STOP
             ENDIF
          ENDIF

      ENDIF

      END SUBROUTINE CHE_HEI
!........................................................................

!--------------------------------------------------------------------
! Calculating (left-border, right-border,width) of given frequency
!--------------------------------------------------------------------
      SUBROUTINE LR(om,tot,hei,olef,orig,wid)
      USE useful_parameters ; IMPLICIT NONE
      REAL*8,INTENT(IN)  :: om,tot,hei
      REAL*8,INTENT(OUT) :: olef,orig,wid
      wid=tot/hei
      olef = om - wid/un2 ; orig = om + wid/un2
      RETURN ;
      END SUBROUTINE LR
!....................................................................

!--------------------------------------------------------------------
!  suggest jump by square inter-extrapolation
!  return logical variable su_succes=.false., if fails
!--------------------------------------------------------------------
      SUBROUTINE SQUARE_SUGGEST(tj,z0,z1,z2,t_best,su_succes)
      USE useful_parameters ;  IMPLICIT NONE

      REAL*8,INTENT(IN)   :: tj,z0,z1,z2
      REAL*8,INTENT(OUT)  :: t_best          !best jump
      LOGICAL,INTENT(OUT) :: su_succes       !succes to calculate

      REAL*8 :: a,b,y0,y1,y2

      su_succes = .true. ;

      IF(z0<1.0d-60 .OR. z1<1.0d-60 .OR. z2<1.0d-60)THEN
      su_succes = .false.; RETURN;
      ENDIF

      y0=un1/z0; y1=un1/z1; y2=un1/z2

      IF(ABS(tj)>=small_jump) THEN ; a=(y2-un2*y1+y0)/(un2*tj**2)
      ELSE ;  su_succes = .false. ; RETURN ;  ENDIF

      IF(a<=0 .OR. ABS(a)<small_jump) THEN
      su_succes = .false. ; RETURN ;  ENDIF

      b = (4.0*y1-y2-3.0*y0) / (un2*tj); t_best = - b / (un2*a)

      END SUBROUTINE SQUARE_SUGGEST
!....................................................................

!--------------------------------------------------------------------
!  Updates gc_global or gc_global_MA with given i_which
!  dependuing of kenel_type
!--------------------------------------------------------------------
      SUBROUTINE UPDATE_GC_GLOBAL(i_which)
      USE global_control; USE ext_control_data; USE time_data
      IMPLICIT NONE
      INTEGER,INTENT(IN) :: i_which

      SELECT CASE(kernel_type)
         CASE(0,1,2,3)
            gc_global(1:nt) = gc_at(i_which,1:nt)
         CASE(4,5)
            gc_global_MA(1:nt) = gc_at_MA(i_which,1:nt)
      END SELECT

      END SUBROUTINE UPDATE_GC_GLOBAL
!....................................................................

!--------------------------------------------------------------------
!  determine restriction for jumps back
!--------------------------------------------------------------------
      REAL*8 FUNCTION RUMBA()
      USE global_control ; USE proc_par ; IMPLICIT NONE
      REAL*8,EXTERNAL :: RNDM
      rumba = RNDM(k) ** (un1/(un1+afe))
      END FUNCTION RUMBA
!....................................................................

!--------------------------------------------------------------------
! Calculating number of closest frequency to frequency number 'num'
! except the same
!--------------------------------------------------------------------
      INTEGER FUNCTION INUS(num)
      USE float_configuration ; IMPLICIT NONE
      INTEGER,INTENT(IN) :: num
      REAL*8 :: a,zu,om
      om=om_0(num); zu=HUGE(ABS(om)); inus=0
      DO i=1,nmnm
         a=ABS(om_0(i)-om);
         IF(a<zu.AND.i/=num)THEN;
            zu=a; inus=i;
         ENDIF
      ENDDO
      IF(inus==0 .OR. inus>nmnm .OR. inus==num) THEN
         PRINT*,'inus=',inus,'nmnm=',nmnm,'num=',num;
         STOP' INUS ERROR '
      ENDIF
      END FUNCTION INUS
!....................................................................

!--------------------------------------------------------------------
! check whether newborn frequency does not duplicate the existing one
!--------------------------------------------------------------------
      SUBROUTINE AVOID_DUPLICATION(om,tot,hei,avoid_dup)
      USE float_configuration; USE proc_par; IMPLICIT NONE
      REAL*8,INTENT(IN)   :: om,tot,hei
      LOGICAL,INTENT(OUT) :: avoid_dup

      REAL*8  :: o_l,o_r,wid,alef,arig,wid_new,cross_area

      avoid_dup=.true.
      CALL LR(om,tot,hei,alef,arig,wid_new)
      DO i=1,nmnm
      CALL LR(om_0(i),to_t0(i),ro_h0(i),o_l,o_r,wid)
      IF(alef>=o_l .AND. arig<=o_r) THEN
         cross_area=MIN(ro_h0(i),hei)*wid_new
         IF(cross_area>=purki*to_t0(i)) avoid_dup=.false.
      ENDIF
      ENDDO

      END SUBROUTINE AVOID_DUPLICATION
!....................................................................

!--------------------------------------------------------------------
! Calculating number of closest frequency to value om
!--------------------------------------------------------------------
      INTEGER FUNCTION INUV(om)
      USE float_configuration ; IMPLICIT NONE
      REAL*8,INTENT(IN) :: om
      REAL*8 :: a,zu
      zu=HUGE(ABS(om)); inuv=0
      DO i=1,nmnm
      a=ABS(om_0(i)-om); IF(a<zu)THEN; zu=a; inuv=i; ENDIF
      ENDDO
      IF(inuv==0 .OR. inuv>nmnm) inuv=1
      RETURN ;
      END FUNCTION INUV
!....................................................................

!--------------------------------------------------------------------
! Suggesting width alteration according to special distribution
!--------------------------------------------------------------------
      REAL*8 FUNCTION CONT_SUGGEST(bmin,stepen)
      USE global_control ; IMPLICIT NONE
      REAL*8,EXTERNAL :: RNDM
      REAL*8,INTENT(IN) :: bmin,stepen
      REAL*8 :: aste,zuz,st1
      IF(stepen-un1<0.001d0)THEN
         cont_suggest=exp(un2*RNDM(k)*log(bmin))/bmin;
         RETURN
      ELSE
         aste=bmin**(stepen-un1); zuz=RNDM(k);
         st1=un1/(stepen-un1)
         cont_suggest=((un1-zuz)*aste+(zuz/aste))**st1
      ENDIF
      END FUNCTION CONT_SUGGEST
!....................................................................

!--------------------------------------------------------------------
! Calculating width shift for width alteration
!--------------------------------------------------------------------
      REAL*8 FUNCTION OM_WID_SHI(om,del,ksi)
      USE global_control ; IMPLICIT NONE
      REAL*8,INTENT(IN) :: om,del,ksi
      REAL*8 :: delta,r_om,r_om_plu,r_om_min,de_om

      IF(ABS(ksi-un1)>0.25d0)THEN;
         om_wid_shi=om; RETURN;
      ENDIF

      delta = un2*del/3.0 ;  r_om = un1/(om**2);
      r_om_min = un1/((om-delta)**2) ; r_om_plu = un1/((om+delta)**2)
      de_om = delta*(ksi-un1)*(r_om_min-r_om_plu);
      de_om = de_om/(r_om+r_om_min+r_om_plu)
      om_wid_shi = om + de_om

      END FUNCTION OM_WID_SHI
!....................................................................

